<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Follow extends Model
{
    public $fillable = [
        'follower_id',
        'following_id',
        'status'
    ];

    public function follower()
    {
        return $this->belongsTo(User::class, 'follower_id', 'id');
    }

    public function following()
    {
        return $this->belongsTo(User::class, 'following_id', 'id');
    }
}
